<?php
include("connexion.php");

$utilisateur_id = intval($_GET['utilisateur_id']); 


$stmt = $db->prepare("SELECT * FROM utilisateurs WHERE id = :id");
$stmt->bindValue(':id', $utilisateur_id, PDO::PARAM_INT);
$stmt->execute();
$utilisateur = $stmt->fetch(PDO::FETCH_ASSOC);

$message = '';

if ($_SERVER["REQUEST_METHOD"] == "POST" && isset($_POST['modifier_utilisateur'])) {
    $login = $_POST['login'];
    $password = $_POST['password'];

    // Hachage du mot de passe
    $hashed_password = password_hash($password, PASSWORD_DEFAULT);

    $stmt = $db->prepare("UPDATE utilisateurs SET login = :login, password = :password WHERE id = :id");
    $stmt->bindValue(':login', $login, PDO::PARAM_STR);
    $stmt->bindValue(':password', $hashed_password, PDO::PARAM_STR);
    $stmt->bindValue(':id', $utilisateur_id, PDO::PARAM_INT);
    $stmt->execute();

    $message = "Mot de passe modifié avec succès.";
}
?>

<!DOCTYPE html>
<html lang="fr">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title>Modifier Utilisateur</title>
    <link href="CSS/mutili.css" rel="stylesheet">
</head>
<body>
<header>
    <div class="logo"><a href="admin.php">ADMIN</a></div> 
    <div class="nav-buttons">
        <a href="deco.php">Déconnexion</a>
    </div>
</header>

<?php if ($message) { ?>
    <div class="message"><?= htmlspecialchars($message) ?></div>
<?php } ?>

<h2>Modifier l'Utilisateur</h2>
<form action="modifutilisateur.php?utilisateur_id=<?= $utilisateur['id'] ?>" method="post">
    <label for="login">Login :</label>
    <input type="text" id="login" name="login" value="<?= htmlspecialchars($utilisateur['login'] ?? '') ?>" required><br>

    <label for="password">Mot de passe :</label>
    <input type="password" id="password" name="password" required><br>

    <input type="submit" name="modifier_utilisateur" value="Modifier">
</form>

<div class='back-button'>
    <button type='button' onclick='window.history.back();'>Retour</button>
</div>

</body>
</html>